<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface AssetsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Assets 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param asset primary key
 	 */
	public function delete($assetId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Assets asset
 	 */
	public function insert($asset,$assetDescription);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Assets asset
 	 */
	public function update($asset,$assetDescription);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAssetsName($value);

	public function queryByAssetsDescription($value);

	public function queryByAssetsValue($value);

	public function queryByAssetsDepreciation($value);

	public function queryByAssetsDate($value);

	public function queryByCondition($value);

	public function queryByUserid($value);


	public function deleteByAssetsName($value);

	public function deleteByAssetsDescription($value);

	public function deleteByAssetsValue($value);

	public function deleteByAssetsDepreciation($value);

	public function deleteByAssetsDate($value);

	public function deleteByCondition($value);

	public function deleteByUserid($value);


}
?>